<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <!--style sheets-->
  <link href="../css/navigation.css" rel="stylesheet" type="text/css" />
  <!--jscript-->
  <script language="JavaScript" src="../jscript/go_to_url.js" type="text/javascript"></script>
  <?php
  // Assuming $con is the mysqli database connection object

  // Get the table name from the session variable
  $table_name = $_SESSION['db_prefix'] . "_saved_sales_reports";

  // Prepare the query with placeholders for values to be bound
  $sales_report_query = "SELECT saved_report_id FROM $table_name WHERE department = ? AND user_name = ? AND read_done = 'no'";

  // Prepare the statement
  $stmt = $con->prepare($sales_report_query);

  // Bind the parameters
  $stmt->bind_param("ss", $department, $user_name); // Assuming 'department' and 'user_name' are the respective variables

  // Set the values of the parameters
  $department = 'sales'; // Assuming 'sales' is the desired department
  $user_name = $_SESSION['username']; // Assuming 'username' is the desired username from the session

  // Execute the statement
  $stmt->execute();

  // Get the result set
  $sales_report_result = $stmt->get_result();

  // Get the number of rows in the result set
  $sales_report_num = $sales_report_result->num_rows;

  // If the number of rows is greater than 5, set it to 6
  if ($sales_report_num > 5) {
    $sales_report_num = 6;
  }

  // Rest of your code...
  ?>

</head>

<body>
  <div class="side_frame"><br />
    <div class="menu_block_frame">
      <div class="side_menu_caption">Input</div>
      <a href="../sales/quoteRequestWiz0.php">
        <div class="side_menu_button">Enquiry</div>
      </a>
      <a href="../sales/quoteWiz0.php">
        <div class="side_menu_button">Capture quote</div>
      </a>
      <a href="../sales/quote_updateWiz0.php">
        <div class="side_menu_button">Status quote</div>
      </a>
      <a href="../sales/qbillWiz0.php">
        <div class="side_menu_button">Bill of quantity</div>
      </a>
      <a href="../sales/edit_select_sales.php">
        <div class="side_menu_button">Edit</div>
      </a>
      <br />
      <div class="side_menu_caption">Reporting</div>
      <a href="../sales/request_list.php?date=0">
        <div class="side_menu_button">Enquiries</div>
      </a>
      <a href="../sales/quotations_list.php?date=0">
        <div class="side_menu_button">Quotations</div>
      </a>
      <a href="../sales/success_list.php?date=0">
        <div class="side_menu_button">Successful jobs</div>
      </a>
      <a href="../sales/customer_list.php">
        <div class="side_menu_button">Customers</div>
      </a>

      <a href="../sales/sales_alerts_list.php?date=&set=&delete=">
        <div class="side_menu_button">
          <div align="center">
            <table width="85" border="0">
              <tr>
                <td height="30" align="center" valign="top" <?php if ($sales_alert_num > 0) { ?> style="background-image:url(../images/alert_circle_<?php echo $sales_alert_num ?>.png); background-repeat:no-repeat;" <?php } ?>>Alerts</td>
              </tr>
            </table>
          </div>
        </div>
      </a>
      <a href="../sales/sales_report_list.php?date=&set=&delete=">
        <div class="side_menu_button">
          <div align="center">
            <table width="85" border="0">
              <tr>
                <td height="30" align="center" valign="top" <?php if ($sales_report_num > 0) { ?> style="background-image:url(../images/alert_circle_<?php echo $sales_report_num ?>.png); background-repeat:no-repeat;" <?php } ?>>Reports</td>
              </tr>
            </table>

          </div>
        </div>
      </a>
      <a href="">
        <div class="side_menu_button"></div>
      </a>
    </div>
  </div>
</body>

</html>