<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <head>
    <link href="../css/main.css" rel="stylesheet" type="text/css" />
    <?php
    include('../include/session.php');

    $day = date("Y-m-d");
    $today = date('l');
    $today_no = date('w');
    $this_month = date('m');
    $this_year = date('Y');
    $no_day = date('t');

    $first_day = $this_year . '-' . $this_month . '-01';
    $last_day = $this_year . '-' . $this_month . '-' . $no_day;

    $table_name2 = $_SESSION['db_prefix'] . "_vehicle";

    // Prepare and execute $reg_query
    $reg_query = "SELECT vehicle_id, registration_no, make, model, department, road_license_date, clock_reading FROM $table_name2 WHERE road_license_date>=? AND road_license_date<=? AND disposal_date = '2030-01-01'";
    $reg_stmt = $con->prepare($reg_query);
    $reg_stmt->bind_param("ss", $first_day, $last_day);
    $reg_stmt->execute();
    $reg_result = $reg_stmt->get_result();
    $reg_num = mysqli_num_rows($reg_result);
    
    // Prepare and execute $ba_query
    $ba_query = "SELECT vehicle_id, registration_no, make, model, department, ba_license_date, clock_reading FROM $table_name2 WHERE ba_license_date>=? AND ba_license_date<=? AND disposal_date = '2030-01-01'";
    $ba_stmt = $con->prepare($ba_query);
    $ba_stmt->bind_param("ss", $first_day, $last_day);
    $ba_stmt->execute();
    $ba_result = $ba_stmt->get_result();
    $ba_num = mysqli_num_rows($ba_result);
    
    // Prepare and execute $insurance_query
    $insurance_query = "SELECT vehicle_id, registration_no, make, model, department, insurance, renewal_date, clock_reading FROM $table_name2 WHERE renewal_date>=? AND renewal_date<=? AND disposal_date = '2030-01-01'";
    $insurance_stmt = $con->prepare($insurance_query);
    $insurance_stmt->bind_param("ss", $first_day, $last_day);
    $insurance_stmt->execute();
    $insurance_result = $insurance_stmt->get_result();
    $insurance_num = mysqli_num_rows($insurance_result);
    
    // Prepare and execute $service_query
    $service_query = "SELECT vehicle_id, registration_no, make, model, clock_reading, last_service_mileage, service_interval, department FROM $table_name2 WHERE disposal_date = '2030-01-01'";
    $service_stmt = $con->prepare($service_query);
    $service_stmt->execute();
    $service_result = $service_stmt->get_result();
    $service_num = mysqli_num_rows($service_result);
    
    ?>
    <script type="text/javascript" src="../jscript/tablesort.js"></script>
    <script language="javascript" src="../jscript/calendar.js"></script>

    <?php include('../include/tooltip.php'); ?>
  </head>
  <link rel="stylesheet" type="text/css" href="../css/tooltip.css" />

<body>
  <?php
  include("../navigation/header.php");
  $page_name = "Transport-main";
  include("../navigation/access.php");

  if ($permission_num == 1) {
    include("../navigation/transport_sidebar.php");
  ?>

    <div class="main_frame" style="height:auto;">
      <div class="page_head_frame">
        <table width="809" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td><label class="label_page_head">Transport
                <?php echo "today, " . date("d-m-Y", strtotime($day));  ?>
              </label></td>
            <td width="171" align="right">&nbsp;</td>
          </tr>
        </table>
      </div>

      <div class="page_middle_frame" style="height:auto;">
        <div class="scroll_frame_medium" style="height:150px;">
          Road licenses:
          <table width="640" id="table_list">
            <tr>
              <th width="119">Registration</th>
              <th width="218">Vehicle</th>
              <th width="327">Department</th>
              <th width="115">Expire</th>
            </tr>
            <?php
            $i = 0;
            while ($row_reg = mysqli_fetch_array($reg_result)) {
              $a0 = $row_reg[ "vehicle_id"];
              $a1 = $row_reg[ "registration_no"];
              $a2 = $row_reg[ "make"];
              $a3 = $row_reg[ "model"];
              $a4 = $row_reg[ "department"];
              $a5 = $row_reg[ "road_license_date"];

              $a11 = number_format($row_reg[ "clock_reading"], 0, '.', ',');

              $vehicleTT = "<table id=table_tool_tip width=250 ><tr><td  width=75>Make/model:</td><td width=175>" . $a2 . ' ' . $a3 . "</td></tr><tr><td>Department:</td><td>" . $a4 . "</td></tr><tr><td>Km reading:</td><td>" . $a11 . "km</td></tr></table><br><b>Click for details</b>";
            ?>
              <tr>
                <td><a href="vehicle_details.php?vehicle_id=<?php echo $a0; ?>" onMouseover="ddrivetip('<?php echo $vehicleTT; ?>  ', 200)" ; onMouseout="hideddrivetip()"><?php echo $a1; ?></a></td>
                <td><?php echo $a2 . " " . $a3; ?></td>
                <td><?php echo $a4; ?></td>
                <td align="center"><?php echo date("d-m-Y", strtotime($a5)); ?></td>
              </tr>
            <?php
              $i++;
            }
            ?>
          </table>
        </div>
        <div class="scroll_frame_medium" style="height:150px;;">
          BA licenses:
          <table width="640" id="table_list">
            <tr>
              <th width="119">Registration</th>
              <th width="218">Vehicle</th>
              <th width="327">Department</th>
              <th width="115">Expire</th>
            </tr>
            <?php
            $i = 0;
            while ($row_ba = mysqli_fetch_assoc($ba_result)) {
              $b0 = $row_ba["vehicle_id"];
              $b1 = $row_ba["registration_no"];
              $b2 = $row_ba["make"];
              $b3 = $row_ba["model"];
              $b4 = $row_ba["department"];
              $b5 = $row_ba["ba_license_date"];
          
              $b11 = number_format($row_ba["clock_reading"], 0, '.', ',');

              $vehicleTT = "<table id=table_tool_tip width=250 ><tr><td  width=75>Make/model:</td><td width=175>" . $b2 . ' ' . $b3 . "</td></tr><tr><td>Department:</td><td>" . $b4 . "</td></tr><tr><td>Km reading:</td><td>" . $b11 . "km</td></tr></table><br><b>Click for details</b>";
            ?>
              <tr>
                <td><a href="vehicle_details.php?vehicle_id=<?php echo $b0; ?>" onMouseover="ddrivetip('<?php echo $vehicleTT; ?>  ', 200)" ; onMouseout="hideddrivetip()"><?php echo $b1; ?></a><a href="vehicle_details.php?vehicle_id=<?php echo $b0; ?>" onMouseover="ddrivetip('<?php echo $vehicleTT; ?>  ', 200)" ; onMouseout="hideddrivetip()"></a></td>
                <td><?php echo $b2 . " " . $b3; ?></td>
                <td><?php echo $b4; ?></td>
                <td align="center"><?php echo date("d-m-Y", strtotime($b5)); ?></td>
              </tr>
            <?php
              $i++;
            }
            ?>
          </table>
        </div>
        <div class="scroll_frame_medium" style="height:150px;">
          Insurance:
          <table width="640" id="table_list">
            <tr>
              <th width="117">Registration</th>
              <th width="216">Vehicle</th>
              <th width="163">Department</th>
              <th width="161">Insured with</th>
              <th width="118">Expire</th>
            </tr>
            <?php
            $i = 0;
            while ($row_insurance = mysqli_fetch_array($insurance_result)) {
              $a0 = $row_insurance[ "vehicle_id"];
              $a1 = $row_insurance[ "registration_no"];
              $a2 = $row_insurance[ "make"];
              $a3 = $row_insurance[ "model"];
              $a4 = $row_insurance[ "department"];
              $a5 = $row_insurance[ "insurance"];
              $a6 = $row_insurance[ "renewal_date"];

              $a11 = number_format($row_insurance[ "clock_reading"], 0, '.', ',');

              $vehicleTT = "<table id=table_tool_tip width=250 ><tr><td  width=75>Make/model:</td><td width=175>" . $a2 . ' ' . $a3 . "</td></tr><tr><td>Department:</td><td>" . $a4 . "</td></tr><tr><td>Km reading:</td><td>" . $a11 . "km</td></tr></table><br><b>Click for details</b>";
            ?>
              <tr>
                <td><a href="vehicle_details.php?vehicle_id=<?php echo $a0; ?>" onMouseover="ddrivetip('<?php echo $vehicleTT ?>  ', 200)" ; onMouseout="hideddrivetip()"><?php echo $a1; ?></a><a href="vehicle_details.php?vehicle_id=<?php echo $a0; ?> " onMouseover="ddrivetip('Click for details', 150)" ; onMouseout="hideddrivetip()"></a></td>
                <td><?php echo $a2 . " " . $a3; ?></td>
                <td><?php echo $a4; ?></td>
                <td><?php echo $a5; ?></td>
                <td align="center"><?php echo date("d-m-Y", strtotime($a6)); ?></td>
              </tr>
            <?php
              $i++;
            }
            ?>
          </table>
          <br />
        </div>
        <div class="scroll_frame_medium" style="height:150px;">
          Service status:
          <table width="640" id="table_list">
            <tr>
              <th width="108">Registration no</th>
              <th width="87">Vehicle</th>
              <th width="89">Current km</th>
              <th width="85">Last service</th>
              <th width="101">Interval</th>
              <th width="142">Status</th>
            </tr>
            <?php
            $i = 0;
            $v8 = '';
            while ($row_service = mysqli_fetch_array($service_result)) {
              $v1 = $row_service[ "vehicle_id"];
              $v2 = $row_service[ "registration_no"];
              $v3 = $row_service[ "make"];
              $v4 = $row_service[ "model"];
              $v5 = $row_service[ "clock_reading"];
              $v6 = $row_service[ "last_service_mileage"];
              $v7 = $row_service[ "service_interval"];
              $v8 = $row_service[ "department"];

              $vehicleTT = "<table id=table_tool_tip width=250 ><tr><td  width=75>Make/model:</td><td width=175>" . $v3 . ' ' . $v4 . "</td></tr><tr><td>Department:</td><td>" . $v8 . "</td></tr><tr><td>Km reading:</td><td>" . number_format($v5, 0, '.', ',') . "km</td></tr></table><br><b>Click for details</b>";

              if (($v5 - $v6) >= $v7) {
                $v8 = 'Overdue by ' . (($v5 - $v6) - $v7) . 'km';
              } else {
                if (($v5 - $v6) >= ($v7 - 1000)) {
                  $v8 = 'Due in ' . ($v7 - ($v5 - $v6)) . 'km';
                } else {
                  if (($v5 - $v6) < $v7) {
                    $v8 = 'OK';
                  }
                }
              }
              if ($v8 == 'OK') {
                $i++;
              } else {
            ?>
                <tr>
                  <td><a href="vehicle_details.php?vehicle_id=<?php echo $v1; ?>" onMouseover="ddrivetip('<?php echo $vehicleTT; ?>  ', 200)" ; onMouseout="hideddrivetip()"><?php echo $v2; ?></a></td>
                  <td><?php echo $v3 . ' ' . $v4; ?></td>
                  <td align="center"><?php echo number_format($v5, 0, '.', ','); ?></td>
                  <td align="center"><?php echo number_format($v6, 0, '.', ','); ?></td>
                  <td align="center"><?php echo number_format($v7, 0, '.', ','); ?></td>
                  <td><?php echo $v8; ?> </td>
                </tr>
            <?php
                $i++;
              }
            }
            ?>
          </table>
        </div>
      </div>
    </div>

  <?php } else {
    $_SESSION['denied_return'] = $_SESSION['location'];
    include("../navigation/transport_sidebar.php"); ?>

    <body onload="accessdenied(); return false">
    </body>
  <?php }
  ?>

  <?php include('../navigation/side_bar.php'); ?>
</body>

</html>