<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<?php
include('../include/session.php');
?>
<!--style sheets-->
<link rel="stylesheet" type="text/css" href="../css/tooltip.css" />
<link rel="stylesheet" type="text/css" href="../css/card.css" />
<!--jscript-->
<script type="text/javascript" src="../jscript/tooltip.js"></script>
</head>
<body>
<?php
$_SESSION['current_page']  = "store";
include ("../navigation/header.php");
$page_name = "Stores-main";
include ("../navigation/access.php");

$table_name_min = $_SESSION['db_prefix'] . "_store_items"; 
$items_min_query = "SELECT store_item_id FROM $table_name_min WHERE quantity < ?";
$stmt_min = $con->prepare($items_min_query);
$stmt_min->bind_param("i", $minimum_stock); // Assuming $minimum_stock is the value for the "quantity" parameter
$stmt_min->execute();
$items_min_result = $stmt_min->get_result();
$items_min_num = mysqli_num_rows($items_min_result);

$table_name_non = $_SESSION['db_prefix'] . "_store_items"; 
$items_non_query = "SELECT store_item_id FROM $table_name_non WHERE (quantity <= 0) AND (minimumStock <> ?) ";
$stmt_non = $con->prepare($items_non_query);
$stmt_non->bind_param("i", $minimum_stock_non); // Assuming $minimum_stock_non is the value for the "minimumStock" parameter
$stmt_non->execute();
$items_non_result = $stmt_non->get_result();
$items_non_num = mysqli_num_rows($items_non_result);



$short_reserved = 0;
$table_name2 = $_SESSION['db_prefix']."_store_items"; 
$reserved_query = "SELECT store_item_id, quantity FROM $table_name2";
$reserved_result = mysqli_query($con,$reserved_query);
$reserved_num = mysqli_num_rows($reserved_result);
$i=0;

while ($row_reserved = mysqli_fetch_array($reserved_result)) {
    $store_item_id = $row_reserved["store_item_id"];
    $stock_qty = $row_reserved["quantity"];

    $table_name = $_SESSION['db_prefix']."_order_job_lines";
    $job_reserved_query = "SELECT SUM(quantity) AS summed_quantity, SUM(delivered) AS summed_delivered FROM $table_name WHERE store_item_id = ? GROUP BY store_item_id";
    $job_reserved_stmt = $con->prepare($job_reserved_query);
    $job_reserved_stmt->bind_param("s", $store_item_id);
    $job_reserved_stmt->execute();
    $job_reserved_result = $job_reserved_stmt->get_result();
    $job_reserved_num = mysqli_num_rows($job_reserved_result);
    $m=0;
    while ($row_job_reserved = mysqli_fetch_array($job_reserved_result)) {
        $reserved = $row_job_reserved["summed_quantity"]-$row_job_reserved["summed_delivered"];
        $m++;
        if ($stock_qty<$reserved) {
            $short_reserved = $short_reserved + 1;
        }
    }
            
    $table_name2 = $_SESSION['db_prefix']."_mworks_order_job_lines";
    $job_reserved2_query = "SELECT SUM(quantity) AS summed_quantity, SUM(delivered) AS summed_delivered FROM $table_name2 WHERE store_item_id = ? GROUP BY store_item_id";
    $job_reserved2_stmt = $con->prepare($job_reserved2_query);
    $job_reserved2_stmt->bind_param("s", $store_item_id);
    $job_reserved2_stmt->execute();
    $job_reserved2_result = $job_reserved2_stmt->get_result();
    $job_reserved2_num = mysqli_num_rows($job_reserved2_result);
    $m=0;
    while ($row_job_reserved2 = mysqli_fetch_array($job_reserved2_result)) {
        $reserved2 = $row_job_reserved2["summed_quantity"]-$row_job_reserved2["summed_delivered"];
        $m++;
        if ($stock_qty<$reserved2) {
            $short_reserved = $short_reserved + 1; 
        }          
    }
    $i++;
}

$table_name = $_SESSION['db_prefix']."_special_orders";
$special_query = "SELECT job_card_no FROM $table_name WHERE date_purchased IS NULL ";
$special_stmt = $con->prepare($special_query);
$special_stmt->execute();
$special_result = $special_stmt->get_result();
$special_num = mysqli_num_rows($special_result);

if ($permission_num==1) {
  include ("../navigation/store_sidebar.php");
?>
<div class="main_frame" style="height:auto;">
  <div class="page_head_frame">
    <table width="640" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><label class="label_page_head">Store </label></td>
        <td width="171" align="right">&nbsp;</td>
      </tr>
    </table>
  </div>
  <div  class="page_middle_frame">
    <div class="page_inside_frame">
      <font size="+2">Stock status:</font><br>
      <br>
      <?= $items_min_num ?> store items below minimum stock. Click <a href="store_status_list.php?status=min">here</a> to view the list.<br>
      <br>
      <?= $items_non_num ?> store items have no stock. Click <a href="store_status_list.php?status=non">here</a> to view the list.<br>
      <br>
      <?= $short_reserved ?> store items are having a higher reserved quantity then actual stock.Click <a href="store_status_reserved_list.php?status=reserved">here</a> to view the list.<br><br>
      <?= $special_num ?> special items are on order but not yet purchased. Click <a href="open_special_order_list.php">here</a> to view the list.<br>
    </div>
  </div>
</div>
</body>
<?php
} else {
  $_SESSION['denied_return'] = $_SESSION['location'];  
  include ("../navigation/store_sidebar.php");
?>
<body onLoad="accessdenied(); return false">
</body>
<?php
}
?>
<?php include ('../navigation/side_bar.php'); ?>
</html>
