
<?php
$today = date("Y-m-d");
$table_name = $_SESSION['db_prefix'] . "_compiled_jobs";
// Prepare the job query
$job_query = "SELECT job_card_no, project, del_date, end_date, cust_id, forman  
              FROM $table_name 
              WHERE compiled = ? AND completed IS NULL 
              ORDER BY job_card_no DESC";
$stmt = $con->prepare($job_query);
$compiled = 'yes';
$stmt->bind_param("s", $compiled); // Bind the parameter value to the query
$stmt->execute(); // Execute the query
$job_result = $stmt->get_result(); // Get the result set

$job_num = $job_result->num_rows; // Get the number of rows in the result set
$data = array();
$i = 0;
while ($i < $job_num) {
	// Fetch the data from the result set
	$row = $job_result->fetch_assoc();
	$job_card_no = $row["job_card_no"];
	$project = $row["project"];
	$start_date = $row["del_date"];
	$end_date = $row["end_date"];
	$chart_end_date = strtotime(date("Y-m-d", strtotime($end_date)) . " +1 day");
	$chart_end_date = date("Y-m-d", $chart_end_date);
	if ($end_date == '') {
		$end_date = $start_date;
	}
	$fore_man = $row["forman"];
	if ($fore_man != '') {
		$table_name2 = $_SESSION['db_prefix'] . "_employee";
		$employee_query = "SELECT emp_first_name, emp_last_name 
                           FROM $table_name2 
                           WHERE emp_id = ?";
		$stmt2 = $con->prepare($employee_query);
		$stmt2->bind_param("s", $fore_man);
		$stmt2->execute();
		$employee_result = $stmt2->get_result();
		$employee_num = $employee_result->num_rows;
		if ($employee_num == 1) {
			$foreman_name = $employee_result->fetch_assoc()["emp_first_name"] . ' ' . $employee_result->fetch_assoc()["emp_last_name"];
		} else {
			$foreman_name = '';
		}
	} else {
		$foreman_name = '';
	}
	$cust_id = $row["cust_id"];
	$table_name2 = $_SESSION['db_prefix'] . "_customer";
	$customer_query = "SELECT * FROM $table_name2 WHERE cust_id = ?";
	$stmt3 = $con->prepare($customer_query);
	$stmt3->bind_param("s", $cust_id);
	$stmt3->execute();
	$customer_result = $stmt3->get_result();
	$customer_num = $customer_result->num_rows;
	if ($customer_num == 1) {
		$a1 = $customer_result->fetch_assoc()["account_type"];
		if ($a1 == "corporate") {
			$cust_name = $customer_result->fetch_assoc()["comp_name"];
		} else {
			
			$cust_name = $customer_result->fetch_assoc()["title"] . " " . $customer_result->fetch_assoc()["name_2"] . " " . $customer_result->fetch_assoc()["comp_name"];
		}
	} else {
		$cust_name = '';
	}
	$table_name = $_SESSION['db_prefix'] . "_planning_legend";
	$legend_query = "SELECT color_code FROM $table_name WHERE emp_id = ?";
	$stmt4 = $con->prepare($legend_query);
	$table_name = $_SESSION['db_prefix'] . "_planning_legend";
	$legend_query = "SELECT color_code FROM $table_name WHERE emp_id = ?";
	$stmt4 = $con->prepare($legend_query);
	$stmt4->bind_param("s", $fore_man); // Bind the parameter value to the query
	$stmt4->execute(); // Execute the query
	$legend_result = $stmt4->get_result(); // Get the result set
	$legend_num = $legend_result->num_rows; // Get the number of rows in the result set
	if ($legend_num == 1) {
		$color_code = $legend_result->fetch_assoc()["color_code"];
	} else {
		$color_code = 'FFF';
	}


	$labelTT = "'<font color=black><table border=0><tr><td width=75 >Job card no:</td><td width=175>" . $job_card_no . "</td></tr><tr><td width=75 >Project:</td><td width=175>" . $project . "</td></tr><tr><td width=75 >Customer:</td><td width=175>" . $cust_name . "</td></tr><tr><td width=75 >Foreman:</td><td width=175>" . $foreman_name . "</td></tr><tr><td width=75 >Start date:</td><td width=175>" . date("d-m-Y", strtotime($start_date)) . "</td></tr><tr><td width=75 >End date:</td><td width=175>" . date("d-m-Y", strtotime($end_date)) . "</td></tr></table></font>'";

	$label = '<a href="edit_planner.php?job_card_no=' . $job_card_no . '" onMouseover="ddrivetip(' . $labelTT . ', 250)"; onMouseout="hideddrivetip()">' . $job_card_no . ' ' . $project . '</a> ';
	$data[] = array(
		'label' => $label,
		'start' => $start_date,
		'end'   => $chart_end_date,
		'class' => $color_code
	);
	$i++;
}


?>